﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using VistATool.Models;
using System.Data.Entity.Validation;

namespace VistATool.Controllers
{
    public class RoomBedController : Controller
    {
        //
        // GET: /RoomBed/

        public ActionResult Index()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                List<ROOM_BED> list = new List<ROOM_BED>();

                foreach (ROOM_BED bed in db.ROOM_BED.ToList())
                {
                    foreach (RMDB_WARDS_WITH_CAN_ASSIGN ward in bed.RMDB_WARDS_WITH_CAN_ASSIGN)
                        bed.Wards += db.WARD_LOCATION.Find(ward.WARDS_WHICH_CAN_ASSIGN_ID).NAME + ",";
                    if (!string.IsNullOrEmpty(bed.Wards) && bed.Wards.Length > 0)
                        bed.Wards = bed.Wards.Substring(0, bed.Wards.Length - 1);                    
                    list.Add(bed);
                }
                return View(list);
            }
        }

        public ActionResult Create()
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["Ward"] = db.WARD_LOCATION.ToList();
                return View();
            }
        }

        [HttpPost]
        public ActionResult Create(ROOM_BED bed)
        {
            try
            {
                if (bed.AssignedWards != null && bed.AssignedWards.Length > 0)
                {
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        foreach (int ward in bed.AssignedWards)
                            bed.RMDB_WARDS_WITH_CAN_ASSIGN.Add(new RMDB_WARDS_WITH_CAN_ASSIGN() { ROOM_BED = bed, WARDS_WHICH_CAN_ASSIGN_ID = ward });                        
                        db.ROOM_BED.Add(bed);
                        db.SaveChanges();
                    }
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["Ward"] = db.WARD_LOCATION.ToList();
            }

            return View();
        }

        public ActionResult Edit(int id)
        {
            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["Ward"] = db.WARD_LOCATION.ToList();
                ROOM_BED bed = db.ROOM_BED.Find(id);
                List<RMDB_WARDS_WITH_CAN_ASSIGN> wardList = bed.RMDB_WARDS_WITH_CAN_ASSIGN.ToList();
                bed.AssignedWards = new int[wardList.Count];
                for (int i = 0; i < wardList.Count; i++)
                    bed.AssignedWards[i] = wardList[i].WARDS_WHICH_CAN_ASSIGN_ID;
                return View(bed);
            }
        }

        [HttpPost]
        public ActionResult Edit(int id, ROOM_BED bed)
        {
            try
            {
                if (bed.AssignedWards != null && bed.AssignedWards.Length > 0)
                {
                    List<RMDB_WARDS_WITH_CAN_ASSIGN> oldWardList = new List<RMDB_WARDS_WITH_CAN_ASSIGN>();
                    using (var db = new BMS_VISTA_DBEntities())
                    {
                        oldWardList = db.RMDB_WARDS_WITH_CAN_ASSIGN.Where(a => a.ROOM_BED_ID == id).ToList();
                        bed.RMDB_WARDS_WITH_CAN_ASSIGN = oldWardList;
                        db.Entry(bed).State = System.Data.EntityState.Modified;
                        db.SaveChanges();
                    //}
                    //using (var db = new BMS_VISTA_DBEntities())
                    //{
                        foreach (int ward in bed.AssignedWards)
                        {
                            if (oldWardList.Where(a => a.WARDS_WHICH_CAN_ASSIGN_ID == ward).FirstOrDefault() == null)
                                db.RMDB_WARDS_WITH_CAN_ASSIGN.Add(new RMDB_WARDS_WITH_CAN_ASSIGN() { ROOM_BED_ID = id, WARDS_WHICH_CAN_ASSIGN_ID = ward });
                        }
                        List<RMDB_WARDS_WITH_CAN_ASSIGN> deletedWards = new List<RMDB_WARDS_WITH_CAN_ASSIGN>();
                        foreach (RMDB_WARDS_WITH_CAN_ASSIGN ward in oldWardList)
                        {
                            if (!bed.AssignedWards.Contains(ward.WARDS_WHICH_CAN_ASSIGN_ID))
                                deletedWards.Add(ward);
                        }
                        for (int i = 0; i < deletedWards.Count; i++)
                            db.Entry(deletedWards[i]).State = System.Data.EntityState.Deleted;
                        db.SaveChanges();                        
                    }
                    return RedirectToAction("Index");
                }
            }
            catch (DbEntityValidationException dbException)
            {
                AddModelErrors(dbException);
            }

            using (var db = new BMS_VISTA_DBEntities())
            {
                ViewData["Ward"] = db.WARD_LOCATION.ToList();
            }
            return View();
        }

        #region Private Methods

        private ModelStateDictionary AddModelErrors(DbEntityValidationException dbException)
        {
            foreach (var validationErrors in dbException.EntityValidationErrors)
            {
                foreach (var validationError in validationErrors.ValidationErrors)
                {
                    this.ModelState.AddModelError(validationError.PropertyName, validationError.ErrorMessage);
                }
            }

            return this.ModelState;
        }

        #endregion

    }
}
